Option Explicit
Const scriptName = "Convert Colors to Process"
Const scriptVer = "1.0.0"

' 1.0.0 - MJM - Initial Release


' Script constants, questions, and error messages.
Const errNoDocument = "This script requires an open document."
Const qConvert = "Convert all colors to Process colors?"

' Enums

' enum crColorSpecSeparationTypes
Const crNoneColor = 0
Const crProcessColor = 1
Const crSpotColor = 2
Const crRegistrationColor = 3




' Main

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim continueOn
Dim tempForErrorCheck
Dim doc1

continueOn = False
Err.Clear
On Error Resume Next
Set doc1 = CreatorApp.ActiveDocument
tempForErrorCheck = doc1.ID
continueOn = (Err = 0)
On Error GoTo 0

If continueOn Then
    If (MsgBox(qConvert, vbYesNo, scriptName) = vbYes) Then
        Dim aColor
        For Each aColor In doc1.ColorSpecs
            If (aColor.Index > 4 And aColor.SeparationType = crSpotColor) Then
                aColor.SeparationType = crProcessColor
            End If
        Next
    End If
Else
    Call MsgBox(errNoDocument, vbOKOnly, scriptName)
End If
